/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.time.frame;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;

import java.io.Serializable;


/**
 * Defines a window of time.
 * <p/>
 * It knows if it is current, and when ask 'next()' returns the frame where current time fits in.
 */
public interface TimeFrame extends Serializable {

  /**
   * Checks that the current time is in the current time frame.
   * 
   * @return true if the current time is inside the time frame windows, false otherwise.
   */
  boolean hasFinished();

  /**
   * @return time in milliseconds until the next time frame starts.
   */
  long millisUntilNextTimeFrame();

  /**
   * @return time in milliseconds of the whole frame.
   */
  long inMillis();

  /**
   * @return TimeFrame that contains the current time.
   *
   *         If this instance contains the current time, then it should return itself.
   */
  TimeFrame next();

  /**
   * @return frame start time.
   */
  DateTime startTime();

  /**
   * 
   * @param dateTime the instant to check
   * @return whether the specified time is within the time frame
   */
  boolean contains(DateTime dateTime);
}
