/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.encryption;

/**
 * Implementation of {@link RuntimeEncrypter} that does not encrypt nor decrypts. It will fail when trying to decrypt a value that
 * is an encryption expression.
 */
public class UnsecuredRuntimeEncrypter extends RuntimeEncrypter {

  @Override
  public String encrypt(String valueToEncrypt) throws GatewayEncryptionException {
    return valueToEncrypt;
  }

  @Override
  public String decrypt(String valueToDecrypt) throws GatewayEncryptionException {
    if (containsEncryptionExpression(valueToDecrypt)) {
      throw new GatewayEncryptionException("Cannot decrypt property " +
          extractValueFromExpression(valueToDecrypt) + " without an encryption key");
    }

    return valueToDecrypt;
  }

}
