/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.expirable;


import com.mulesoft.mule.runtime.gw.api.expirable.Expirable;
import com.mulesoft.mule.runtime.gw.api.time.frame.TimeFrame;

import java.io.Serializable;

/**
 * {@inheritDoc}
 * <p>
 * Uses a {@link TimeFrame} to decide whether this instance has expired.
 *
 * @param <T> object type to treat as {@link Expirable}.
 */
public class TimeExpirable<T extends Serializable> implements Expirable<T> {

  private final T value;
  private final TimeFrame period;

  public TimeExpirable(T value, TimeFrame period) {
    this.value = value;
    this.period = period;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isExpired() {
    return period.hasFinished();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public T value() {
    return value;
  }
}
