/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.time.frame;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;
import com.mulesoft.mule.runtime.gw.api.time.clock.Clock;
import com.mulesoft.mule.runtime.gw.api.time.frame.TimeFrame;
import com.mulesoft.mule.runtime.gw.api.time.frame.TimeFrameFactory;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public class FixedTimeFrameFactory extends TimeFrameFactory {

  protected final DateTime startTime;

  public FixedTimeFrameFactory(Clock clock, DateTime startTime) {
    super(clock);
    this.startTime = startTime;
  }

  @Override
  public TimeFrame createCurrentWith(Period period) {
    period.updateWith(clock);
    return createWith(period).next();
  }

  @Override
  public TimeFrame createWith(Period period) {
    return new FixedTimeFrame(clock, startTime, period);
  }
}
