/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.time.period;

import com.mulesoft.mule.runtime.gw.api.time.clock.Clock;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public class SecondsPeriod extends Period {

  private static final long serialVersionUID = 7825902207032512388L;
  private final MillisPeriod period;

  public SecondsPeriod(int seconds) {
    this((long) seconds);
  }

  public SecondsPeriod(long seconds) {
    this.period = new MillisPeriod(seconds * 1000);
  }

  @Override
  public void updateWith(Clock clock) {

  }

  @Override
  public long inMillis() {
    return period.inMillis();
  }

  @Override
  public boolean equals(Object o) {
    if (o == null || !(o instanceof Period)) {
      return false;
    }

    Period that = (Period) o;

    return period.inMillis() == that.inMillis();
  }

  @Override
  public int hashCode() {
    return period.hashCode();
  }

  @Override
  public String toString() {
    return "Seconds{" +
        "period=" + period.inMillis() + "ms}";
  }
}
