/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.config;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import com.mulesoft.mule.runtime.gw.api.config.ExternalAuthConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;

import org.junit.After;
import org.junit.Test;

public class ExternalAuthConfigurationTestCase {

  private ExternalAuthConfiguration configuration = new GatewayConfiguration().externalAuth();
  private static final int MAX_CACHE_SIZE = 10000;

  @After
  public void tearDown() {
    System.clearProperty("anypoint.platform.external_authentication_provider_enable_proxy_settings");
    System.clearProperty("anypoint.platform.oauth2_cache_max_size");
    System.clearProperty("anypoint.platform.open_am_cache_max_size");
    System.clearProperty("anypoint.platform.ping_federate_cache_max_size");
  }

  @Test
  public void proxyEnabledDefault() {
    assertFalse(configuration.isProxyEnabled());
  }

  @Test
  public void proxyEnabled() {
    System.setProperty("anypoint.platform.external_authentication_provider_enable_proxy_settings", "true");
    assertTrue(configuration.isProxyEnabled());
  }

  @Test
  public void oauthCacheMaxSizeDefault() {
    assertEquals(configuration.getOauthCacheMaxSize(), MAX_CACHE_SIZE);
  }

  @Test
  public void oauthCacheMaxSizeInvalid() {
    System.setProperty("anypoint.platform.oauth2_cache_max_size", "invalid");
    assertEquals(configuration.getOauthCacheMaxSize(), MAX_CACHE_SIZE);
  }

  @Test
  public void oauthCacheMaxSize() {
    System.setProperty("anypoint.platform.oauth2_cache_max_size", "100");
    assertEquals(configuration.getOauthCacheMaxSize(), 100);
  }

  @Test
  public void openAmCacheMaxSizeDefault() {
    assertEquals(configuration.getOpenAmCacheMaxSize(), MAX_CACHE_SIZE);
  }

  @Test
  public void openAmCacheMaxSizeInvalid() {
    System.setProperty("anypoint.platform.open_am_cache_max_size", "invalid");
    assertEquals(configuration.getOpenAmCacheMaxSize(), MAX_CACHE_SIZE);
  }

  @Test
  public void openAmCacheMaxSize() {
    System.setProperty("anypoint.platform.open_am_cache_max_size", "100");
    assertEquals(configuration.getOpenAmCacheMaxSize(), 100);
  }

  @Test
  public void pfCacheMaxSizeDefault() {
    assertEquals(configuration.getPingFederateCacheMaxSize(), MAX_CACHE_SIZE);
  }

  @Test
  public void pfCacheMaxSizeInvalid() {
    System.setProperty("anypoint.platform.ping_federate_cache_max_size", "invalid");
    assertEquals(configuration.getPingFederateCacheMaxSize(), MAX_CACHE_SIZE);
  }

  @Test
  public void pfCacheMaxSize() {
    System.setProperty("anypoint.platform.ping_federate_cache_max_size", "100");
    assertEquals(configuration.getPingFederateCacheMaxSize(), 100);
  }

}
