/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.time.frame;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;
import com.mulesoft.mule.runtime.gw.api.time.clock.Clock;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.mule.runtime.gw.internal.time.frame.FixedTimeFrameFactory;

public abstract class TimeFrameFactory {

  protected final Clock clock;

  public TimeFrameFactory(Clock clock) {
    this.clock = clock;
  }

  public abstract TimeFrame createCurrentWith(Period period);

  public abstract TimeFrame createWith(Period period);

  public static TimeFrameFactory fixed(Clock clock, DateTime startTime) {
    return new FixedTimeFrameFactory(clock, startTime);
  }
}
