/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.encryption;

import org.mule.encryption.Encrypter;
import org.mule.encryption.jce.JCEEncrypter;
import org.mule.encryption.key.EncryptionKeyFactory;
import org.mule.encryption.key.SymmetricKeyFactory;

import javax.crypto.spec.SecretKeySpec;

/**
 * Builds a new {@link Encrypter} with the selected parameterization
 */
public class GatewayEncrypterBuilder {

  private String key;
  private String transformation;
  private String algorithm;

  public GatewayEncrypterBuilder() {}

  public GatewayEncrypterBuilder key(String key) {
    this.key = key;
    return this;
  }

  public GatewayEncrypterBuilder algorithm(String algorithm) {
    this.algorithm = algorithm;
    return this;
  }

  public GatewayEncrypterBuilder transformation(String transformation) {
    this.transformation = transformation;
    return this;
  }

  public Encrypter build() {
    EncryptionKeyFactory keyFactory = (SymmetricKeyFactory) () -> new SecretKeySpec(key.getBytes(), algorithm);
    return new JCEEncrypter(transformation, keyFactory);
  }

}
