/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.time.clock;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;
import com.mulesoft.mule.runtime.gw.api.time.clock.Clock;

/**
 * Defines a Clock that uses the current system time.
 */
public class SystemClock extends Clock {

  private static final long serialVersionUID = -2092378019442431156L;

  @Override
  protected DateTime currentTime() {
    return new DateTime(System.currentTimeMillis());
  }

}
