/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.time.period;

import com.mulesoft.mule.runtime.gw.api.time.clock.Clock;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public class MillisPeriod extends Period {

  private static final long serialVersionUID = -1051559621035363325L;
  private final long period;

  public MillisPeriod(long period) {
    this.period = period;
  }

  @Override
  public void updateWith(Clock clock) {
    // TODO this clock will be useful in Calendar periods as its duration will depend on which month, year it is in.
  }

  @Override
  public long inMillis() {
    return this.period;
  }

  @Override
  public boolean equals(Object o) {
    if (o == null || !(o instanceof Period)) {
      return false;
    }

    Period anotherPeriod = (Period) o;

    return this.period == anotherPeriod.inMillis();
  }

  @Override
  public String toString() {
    return "MillisPeriod{" +
        "period=" + period +
        '}';
  }
}
