/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.expirable.mock;

import com.mulesoft.mule.runtime.gw.api.expirable.Expirable;
import com.mulesoft.mule.runtime.gw.api.expirable.ExpirableObjectFactory;

import java.io.Serializable;

public class ControlledExpirableObjectFactory<T extends Serializable> implements ExpirableObjectFactory<T> {

  boolean expired = false;

  @Override
  public Expirable<T> create(T value) {
    return new ControlledExpirable<>(value, this);
  }

  public void expireAll() {
    expired = true;
  }

  static class ControlledExpirable<T extends Serializable> implements Expirable<T> {

    private final T value;
    private final ControlledExpirableObjectFactory<T> parent;

    public ControlledExpirable(T value, ControlledExpirableObjectFactory<T> parent) {
      this.value = value;
      this.parent = parent;
    }

    @Override
    public boolean isExpired() {
      return parent.expired;
    }

    @Override
    public T value() {
      return value;
    }
  }
}
