/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.config;

import static com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode.DISABLED;
import static com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode.FLEXIBLE;
import static com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode.STRICT;
import static java.lang.Boolean.valueOf;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;

import org.junit.After;
import org.junit.Test;

public class GateKeeperConfigurationTestCase {

  private GateKeeperConfiguration configuration = new GatewayConfiguration().gateKeeper();

  @After
  public void tearDown() {
    System.clearProperty("anypoint.platform.gatekeeper");
  }

  @Test
  public void gateKeeperFlexibleDefault() {
    assertThat(configuration.isEnabled(), is(valueOf(true)));
    assertThat(configuration.mode(), is(FLEXIBLE));
  }

  @Test
  public void gateKeeperFalseIsFlexible() {
    System.setProperty("anypoint.platform.gatekeeper", "false");
    assertThat(configuration.isEnabled(), is(true));
    assertThat(configuration.mode(), is(FLEXIBLE));
  }

  @Test
  public void gateKeeperDisabledIsDisabled() {
    System.setProperty("anypoint.platform.gatekeeper", "disabled");
    assertThat(configuration.isEnabled(), is(false));
    assertThat(configuration.mode(), is(DISABLED));
  }

  @Test
  public void gateKeeperDisabledDifferentCaseIsDisabled() {
    System.setProperty("anypoint.platform.gatekeeper", "DisabLeD");
    assertThat(configuration.isEnabled(), is(false));
    assertThat(configuration.mode(), is(DISABLED));
  }

  @Test
  public void gateKeeperTrueIsFlexible() {
    System.setProperty("anypoint.platform.gatekeeper", "true");
    assertThat(configuration.isEnabled(), is(true));
    assertThat(configuration.mode(), is(FLEXIBLE));
  }

  @Test
  public void gateKeeperStrictIsStrict() {
    System.setProperty("anypoint.platform.gatekeeper", "strict");
    assertThat(configuration.isEnabled(), is(true));
    assertThat(configuration.mode(), is(STRICT));
  }

  @Test
  public void gateKeeperStrictDifferentCaseIsStrict() {
    System.setProperty("anypoint.platform.gatekeeper", "STRict");
    assertThat(configuration.isEnabled(), is(true));
    assertThat(configuration.mode(), is(STRICT));
  }

  @Test
  public void gateKeeperInvalidIsFlexible() {
    System.setProperty("anypoint.platform.gatekeeper", "invalidValue");
    assertThat(configuration.isEnabled(), is(true));
    assertThat(configuration.mode(), is(FLEXIBLE));
  }

  @Test
  public void gateKeeperFlexibleIsFlexible() {
    System.setProperty("anypoint.platform.gatekeeper", "flexible");
    assertThat(configuration.isEnabled(), is(true));
    assertThat(configuration.mode(), is(FLEXIBLE));
  }

  @Test
  public void gateKeeperFlexibleDifferentCaseIsFlexible() {
    System.setProperty("anypoint.platform.gatekeeper", "FLexiBLE");
    assertThat(configuration.isEnabled(), is(true));
    assertThat(configuration.mode(), is(FLEXIBLE));
  }

}
