/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.config;

import static java.lang.Boolean.valueOf;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.ProxyConfiguration;

import org.junit.After;
import org.junit.Test;

public class ProxyConfigurationTestCase {

  private ProxyConfiguration configuration = new GatewayConfiguration().proxy();

  @After
  public void tearDown() {
    System.clearProperty("anypoint.platform.x_forwarded_headers_propagation");
  }

  @Test
  public void propagateHeadersDefault() {
    assertThat(configuration.propagateXForwardedHeaders(), is(valueOf(true)));
  }

  @Test
  public void propagateHeaders() {
    System.setProperty("anypoint.platform.x_forwarded_headers_propagation", "false");
    assertThat(configuration.propagateXForwardedHeaders(), is(false));
  }

}
