/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.time;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import com.mulesoft.mule.runtime.gw.api.time.clock.Clock;
import com.mulesoft.mule.runtime.gw.api.time.clock.ManualClock;

import org.junit.Test;

public class ClockTestCase {

  public static final long DATE_TIME_IN_MILLIS = 100L;
  private static final long OFFSET_IN_MILLIS = 10L;

  @Test
  public void correctClockIsIdempotent() {

    Clock clock = new ManualClock(DATE_TIME_IN_MILLIS);
    Clock offsetClock = new ManualClock(DATE_TIME_IN_MILLIS + OFFSET_IN_MILLIS);

    clock.correctWith(offsetClock);
    assertThat(clock.offset(), is(OFFSET_IN_MILLIS));

    clock.correctWith(offsetClock);
    assertThat(clock.offset(), is(OFFSET_IN_MILLIS));

  }
}
