/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import static java.util.Optional.ofNullable;
import static org.apache.commons.lang3.StringUtils.trimToNull;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuntimeConfiguration {

  static final Logger LOGGER = LoggerFactory.getLogger(RuntimeConfiguration.class);

  protected int parseIntOrDefault(String propertyName, int defaultValue) {
    String property = null;
    try {
      property = System.getProperty(propertyName);
      return property != null ? Integer.parseInt(property) : defaultValue;
    } catch (NumberFormatException e) {
      LOGGER.warn("{} is not a valid integer. {} will be used for {}", property, defaultValue, propertyName);
      return defaultValue;
    }
  }

  protected int parsePositive0IntOrDefault(String propertyName, int defaultValue) {
    int value = parseIntOrDefault(propertyName, defaultValue);
    if (value < 0) {
      LOGGER.warn("{} is a negative integer. {} will be used for {}", value, defaultValue, propertyName);
      value = defaultValue;
    }
    return value;
  }

  protected long parseLongOrDefault(String propertyName, long defaultValue) {
    String property = null;
    try {
      property = System.getProperty(propertyName);
      return property != null ? Long.parseLong(property) : defaultValue;
    } catch (NumberFormatException e) {
      LOGGER.warn("{} is not a valid integer. {} will be used for {}", property, defaultValue, propertyName);
      return defaultValue;
    }
  }

  protected boolean parseBooleanOrDefault(String propertyName, boolean defaultValue) {
    return ofNullable(trimToNull(System.getProperty(propertyName)))
        .map(Boolean::valueOf)
        .orElse(defaultValue);
  }

}
