/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.exception;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class ForbiddenClientException extends MuleException {

  private static final long serialVersionUID = 7955628427361125812L;

  public ForbiddenClientException() {
    this("Invalid client id or secret");
  }

  public ForbiddenClientException(String description) {
    super(createStaticMessage(description));
  }

}
