/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.expirable;

import com.mulesoft.mule.runtime.gw.api.time.frame.TimeFrameFactory;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.mule.runtime.gw.internal.expirable.TimeExpirableObjectFactory;

import java.io.Serializable;

/**
 * Factory in charge of creating {@link Expirable} objects.
 *
 * @param <T> type to be wrapped withing an {@link Expirable}.
 */
public interface ExpirableObjectFactory<T extends Serializable> {

  /**
   * @return a wrap of {@link T} that can expire.
   */
  Expirable<T> create(T value);

  static <T extends Serializable> ExpirableObjectFactory<T> timeExpirableFactory(TimeFrameFactory timeFrameFactory,
                                                                                 Period expirationPeriod) {
    return new TimeExpirableObjectFactory<>(timeFrameFactory, expirationPeriod);
  }
}
