/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.policy;

import java.io.Serializable;

public class PolicyTemplateKey implements Serializable {

  private static final long serialVersionUID = 7010821846359164221L;
  private String groupId;
  private String assetId;
  private String version;

  public PolicyTemplateKey(String groupId, String assetId, String version) {
    this.groupId = groupId;
    this.assetId = assetId;
    this.version = version;
  }

  public String getName() {
    return assetId + "-" + version;
  }

  public String getGroupId() {
    return groupId;
  }

  public String getAssetId() {
    return assetId;
  }

  public String getVersion() {
    return version;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    PolicyTemplateKey that = (PolicyTemplateKey) o;

    if (groupId != null ? !groupId.equals(that.groupId) : that.groupId != null) {
      return false;
    }
    if (assetId != null ? !assetId.equals(that.assetId) : that.assetId != null) {
      return false;
    }
    return version != null ? version.equals(that.version) : that.version == null;
  }

  @Override
  public int hashCode() {
    int result = groupId != null ? groupId.hashCode() : 0;
    result = 31 * result + (assetId != null ? assetId.hashCode() : 0);
    result = 31 * result + (version != null ? version.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "TemplateKey " + groupId + ":" + getName();
  }
}
