/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.threading;

import com.mulesoft.mule.runtime.gw.api.time.period.Period;

/**
 * Defines an strategy to sleep current {@link Thread}.
 */
public interface SleepingStrategy {

  /**
   * Sleeps the current {@link Thread} for a {@link Period}.
   * 
   * @param period to sleep.
   * @return this.
   */
  SleepingStrategy sleep(Period period);
}
