/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.time.period;

import static java.lang.Math.round;

import com.mulesoft.mule.runtime.gw.api.time.clock.Clock;
import com.mulesoft.mule.runtime.gw.internal.time.period.MillisPeriod;
import com.mulesoft.mule.runtime.gw.internal.time.period.SecondsPeriod;

import java.io.Serializable;

/**
 * This object represent a period of time.
 * <p/>
 * Each Period define it's duration time in milliseconds. Also, it knows a clock with the current time, useful when defining
 * calendar periods.
 */
public abstract class Period implements Serializable {

  private static final long serialVersionUID = -1299648940427100078L;

  /**
   * Period duration can be dependant to the current clock, therefore one can be set.
   *
   * @param clock Clock.
   */
  public abstract void updateWith(Clock clock);

  /**
   * @return Time duration of the period in milliseconds
   */
  public abstract long inMillis();

  /**
   * @return Time duration of the period in seconds, value will be rounded if it's not integer.
   */
  public long inSeconds() {
    return round(inMillis() / 1000.0);
  }

  public static Period millis(long period) {
    return new MillisPeriod(period);
  }

  public static Period seconds(int seconds) {
    return new SecondsPeriod(seconds);
  }

  public static Period seconds(long seconds) {
    return new SecondsPeriod(seconds);
  }
}
