/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.encryption;

import org.mule.encryption.Encrypter;

import com.mulesoft.mule.runtime.gw.api.config.GatewaySecurityConfiguration;

public class RuntimeEncrypterFactory {

  /**
   * Creates a {@link RuntimeEncrypter} based on how the runtime is configured
   */
  public static RuntimeEncrypter createDefaultRuntimeEncrypter() {
    GatewaySecurityConfiguration config = new GatewaySecurityConfiguration();

    return config.isEncryptionEnabled() ? createRuntimeEncrypter(config.getEncryptionKey()) : new UnsecuredRuntimeEncrypter();
  }

  /**
   * Creates a {@link RuntimeEncrypter} that uses the given encryption key
   */
  public static RuntimeEncrypter createRuntimeEncrypter(String encryptionKey) {
    return new DefaultRuntimeEncrypter(buildDefaultEncrypter(encryptionKey));
  }

  private static Encrypter buildDefaultEncrypter(String key) {
    return new GatewayEncrypterBuilder()
        .key(key)
        .algorithm("AES")
        .transformation("AES/CBC/PKCS5Padding")
        .build();
  }

}
