/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.security;

import java.util.HashMap;
import java.util.Map;

public class ClientAuthenticationBuilder {

  public static final String CLIENT_ID_KEY = "clientId";
  public static final String CLIENT_NAME_KEY = "clientName";

  private String clientId;
  private String clientSecret;
  private String clientName;
  private Map<String, Object> properties = new HashMap<>();

  public ClientAuthenticationBuilder withClientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

  public ClientAuthenticationBuilder withClientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
    return this;
  }

  public ClientAuthenticationBuilder withClientName(String clientName) {
    this.clientName = clientName;
    return this;
  }

  public ClientAuthenticationBuilder withProperties(Map<String, Object> properties) {
    this.properties = properties != null ? new HashMap<>(properties) : new HashMap<>();
    return this;
  }

  /**
   * When building the {@link ClientAuthentication}, the clientId and clientName are also placed in the authentication properties
   * in order to be able to propagate them between different {@link org.mule.runtime.api.security.Authentication} implementations
   * without having to do any mapping.
   *
   * @return the just built {@link ClientAuthentication}
   */
  public ClientAuthentication build() {
    if (clientId != null) {
      properties.put(CLIENT_ID_KEY, clientId);
    }

    if (clientName != null) {
      properties.put(CLIENT_NAME_KEY, clientName);
    }

    return new ClientAuthentication(clientId, clientSecret, properties);
  }

}
