/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.security;

import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.core.api.security.AbstractSecurityProvider;

/**
 * Security provider for {@link ClientAuthentication}s that just let it go through. It does not make any validations
 */
public class GatewaySecurityProvider extends AbstractSecurityProvider {

  public GatewaySecurityProvider(String name) {
    super(name);
  }

  @Override
  public Authentication authenticate(Authentication authentication) throws SecurityException {
    return authentication;
  }

  @Override
  public boolean supports(Class<?> aClass) {
    return ClientAuthentication.class.isAssignableFrom(aClass);
  }
}
