/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.config;

import static java.lang.Boolean.valueOf;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.ThrottlingConfiguration;

import org.junit.After;
import org.junit.Test;

public class ThrottlingConfigurationTestCase {

  private ThrottlingConfiguration configuration = new GatewayConfiguration().throttling();

  @After
  public void tearDown() {
    System.clearProperty("throttling.persistence_enabled");
    System.clearProperty("throttling.persistent_data_update_freq");
  }

  @Test
  public void shouldPersistDefault() {
    assertThat(configuration.shouldPersist(), is(valueOf(true)));
  }

  @Test
  public void shouldPersist() {
    System.setProperty("throttling.persistence_enabled", "false");
    assertThat(configuration.shouldPersist(), is(false));
  }

  @Test
  public void policiesPollFrequencyDefault() {
    assertEquals(configuration.frequency(), 10);
  }

  @Test
  public void policiesPollFrequencyInvalid() {
    System.setProperty("throttling.persistent_data_update_freq", "invalid");
    assertEquals(configuration.frequency(), 10);
  }

  @Test
  public void policiesPollFrequencyPropertyValue() {
    System.setProperty("throttling.persistent_data_update_freq", "30");
    assertEquals(configuration.frequency(), 30);
  }

}
