/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.encryption;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.MatcherAssert.assertThat;

import org.mule.encryption.exception.MuleEncryptionException;

import com.mulesoft.mule.runtime.gw.internal.encryption.UnsecuredRuntimeEncrypter;

import org.junit.BeforeClass;
import org.junit.Test;

public class UnsecuredRuntimeEncrypterTestCase {

  private static final String BASE64_ENCRYPTED = "![vql8bvKsomPVuwWWaBZLlA==]";
  private static final String ORIGINAL_VALUE = "Geronimooooo";

  private static UnsecuredRuntimeEncrypter encrypter;

  @BeforeClass
  public static void setUpEncrypter() {
    encrypter = new UnsecuredRuntimeEncrypter();
  }

  @Test
  public void notEncryptedValueIsNotEncrypted() throws MuleEncryptionException {
    String encryptedValue = encrypter.encrypt(ORIGINAL_VALUE);

    assertThat(encryptedValue, is(ORIGINAL_VALUE));
  }

  @Test
  public void notEncryptedValueIsNotDecrypted() throws MuleEncryptionException {
    String decryptedValue = encrypter.decrypt(ORIGINAL_VALUE);

    assertThat(decryptedValue, is(ORIGINAL_VALUE));
  }

  @Test
  public void alreadyEncryptedValueIsMaintained() throws MuleEncryptionException {
    String encryptedValue = encrypter.encrypt(BASE64_ENCRYPTED);

    assertThat(encryptedValue, is(BASE64_ENCRYPTED));
  }

  @Test
  public void decryptingEncryptionExpressionFails() throws MuleEncryptionException {
    String encryptedValue = encrypter.decrypt(ORIGINAL_VALUE);

    assertThat(encryptedValue, is(ORIGINAL_VALUE));
  }

  @Test
  public void encryptingNullDoesNotFail() throws MuleEncryptionException {
    String encryptedValue = encrypter.encrypt(null);

    assertThat(encryptedValue, nullValue());
  }

  @Test
  public void decryptingNullDoesNotFail() {
    String encryptedValue = encrypter.decrypt(null);

    assertThat(encryptedValue, nullValue());
  }

}
