/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.security;

import static com.mulesoft.mule.runtime.gw.api.security.ClientAuthenticationBuilder.CLIENT_ID_KEY;
import static com.mulesoft.mule.runtime.gw.api.security.ClientAuthenticationBuilder.CLIENT_NAME_KEY;
import static org.hamcrest.Matchers.hasEntry;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

import com.mulesoft.mule.runtime.gw.api.security.ClientAuthentication;
import com.mulesoft.mule.runtime.gw.api.security.ClientAuthenticationBuilder;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

import org.junit.Before;
import org.junit.Test;

public class ClientAuthenticationBuilderTestsCase {

  private static final String CLIENT_ID = "clientId";
  private static final String CLIENT_NAME = "clientName";
  private static final String CLIENT_SECRET = "clientSecret";
  private static final Map<String, Object> PROPERTIES = ImmutableMap.of("key", "value");

  private ClientAuthenticationBuilder builder;

  @Before
  public void setUp() {
    builder = new ClientAuthenticationBuilder();
  }

  @Test
  public void buildFullClient() {
    builder.withClientId(CLIENT_ID)
        .withClientSecret(CLIENT_SECRET)
        .withClientName(CLIENT_NAME)
        .withProperties(PROPERTIES);

    ClientAuthentication authentication = builder.build();

    assertThat(authentication.getPrincipal(), is(CLIENT_ID));
    assertThat(authentication.getCredentials(), is(CLIENT_SECRET));
    assertThat(authentication.getProperties().entrySet(), hasSize(3));
    assertThat(authentication.getProperties(), hasEntry(CLIENT_ID_KEY, CLIENT_ID));
    assertThat(authentication.getProperties(), hasEntry(CLIENT_NAME_KEY, CLIENT_NAME));
    assertThat(authentication.getProperties(), hasEntry("key", "value"));
  }

  @Test
  public void buildWithoutClient() {
    builder.withProperties(PROPERTIES);

    ClientAuthentication authentication = builder.build();

    assertThat(authentication.getPrincipal(), nullValue());
    assertThat(authentication.getCredentials(), nullValue());
    assertThat(authentication.getProperties().entrySet(), hasSize(1));
    assertThat(authentication.getProperties(), hasEntry("key", "value"));
  }
}
