/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.client;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.construction.Builder;
import com.mulesoft.mule.runtime.gw.internal.client.ValidCoreServicesClient;
import java.util.Objects;
import java.util.Set;

public abstract class CoreServicesClient
extends Client {
    private static final long serialVersionUID = -6715117168971723346L;

    public abstract Set<String> redirectionUris();

    public static ClientBuilder getBuilder() {
        return new ClientBuilder();
    }

    public static class ClientBuilder
    implements Builder<CoreServicesClient> {
        private String id;
        private String secret;
        private String name;
        private Set<String> redirectionUris;

        public ClientBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public ClientBuilder withSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public ClientBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ClientBuilder withRedirectionUris(Set<String> redirectionUris) {
            this.redirectionUris = redirectionUris;
            return this;
        }

        @Override
        public CoreServicesClient build() {
            Objects.requireNonNull(this.id, "Cannot create a Client without its ID");
            Objects.requireNonNull(this.secret, "Cannot create a Client without its Secret");
            return new ValidCoreServicesClient(this.id, this.secret, this.name, this.redirectionUris);
        }
    }
}

