/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.configuration;

import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import java.util.List;

/**
 * Retrieves {@link BackoffConfiguration} specific to the use case. Also, abstracts the {@link BackoffConfiguration} building
 * process from the Gateway.
 */
public class BackoffConfigurationSupplier {

  /**
   * Creates a {@link BackoffConfiguration} that can be use to schedule {@link BackoffRunnable}s indefinitely.
   * 
   * @param statusCodes List of status codes.
   * @param backoffEnabled Stating of the backoff is enabled.
   * @return a {@link BackoffConfiguration}.
   */
  public BackoffConfiguration forScheduling(List<Integer> statusCodes, boolean backoffEnabled) {
    return new BackoffConfiguration.Builder(backoffEnabled).statusCodes(statusCodes).build();
  }

  /**
   * Creates a {@link BackoffConfiguration} that can be use to schedule until successful a {@link BackoffRunnable}.
   * 
   * @param statusCodes List of status codes.
   * @param backoffEnabled Stating of the backoff is enabled.
   * @return a {@link BackoffConfiguration}.
   */
  public BackoffConfiguration forScheduleOnce(List<Integer> statusCodes, boolean backoffEnabled) {
    return new BackoffConfiguration.Builder(backoffEnabled).statusCodes(statusCodes).fastRecovery().build();
  }
}
