/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.function;

import static java.lang.Math.ceil;

import java.util.function.Function;

/**
 * Maps {@link Double}s to {@link Integer}s applying ceil of the values.
 */
public class Round implements Function<Integer, Integer> {

  private final Function<Integer, Double> function;

  public Round(Function<Integer, Double> function) {
    this.function = function;
  }

  @Override
  public Integer apply(Integer x) {
    return (int) ceil(function.apply(x));
  }

  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (o == null || getClass() != o.getClass())
      return false;

    Round round = (Round) o;

    return function.equals(round.function);
  }

  @Override
  public int hashCode() {
    return function.hashCode();
  }

  @Override
  public String toString() {
    return "Round{" +
        "function=" + function +
        '}';
  }
}
