/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.function.dispersion;

import java.util.Random;
import java.util.function.Function;

/**
 * Disperses using a uniform distribution, each value within the configured range.
 */
public class RangeDispersant implements Function<Double, Double> {

  private final double from;
  private final double to;
  private Random random;

  public RangeDispersant(double from, double to) {
    this.from = from;
    this.to = to;
    this.random = new Random();
  }

  @Override
  public Double apply(Double value) {
    return value * (random.nextDouble() * from + (to - from));
  }

  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (o == null || getClass() != o.getClass())
      return false;

    RangeDispersant that = (RangeDispersant) o;

    if (Double.compare(that.from, from) != 0)
      return false;
    return Double.compare(that.to, to) == 0;
  }

  @Override
  public int hashCode() {
    int result;
    long temp;
    temp = Double.doubleToLongBits(from);
    result = (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(to);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    return result;
  }

  @Override
  public String toString() {
    return "RangeDispersant{" +
        "from=" + from +
        ", to=" + to +
        '}';
  }
}
