/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.scheduler.configuration;

import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.anypoint.backoff.scheduler.observer.FastRecoveryObserver;
import com.mulesoft.anypoint.backoff.scheduler.runnable.FastRecovery;

import java.util.ArrayList;
import java.util.List;

/**
 * Wraps a {@link SchedulingConfiguration}, adding {@link FastRecoveryObserver}s for a {@link FastRecovery} scenario.
 */
public class FastRecoveryConfiguration {

  private final SchedulingConfiguration schedulingConfiguration;
  private final List<FastRecoveryObserver> observers;

  public FastRecoveryConfiguration(SchedulingConfiguration configuration, List<FastRecoveryObserver> observers) {
    this.schedulingConfiguration = configuration;
    this.observers = observers;
  }

  public List<FastRecoveryObserver> observers() {
    return new ArrayList<>(observers);
  }

  public Period frequency() {
    return schedulingConfiguration.frequency();
  }

  public Period delay() {
    return schedulingConfiguration.delay();
  }

  @Override
  public String toString() {
    return "FastRecoveryConfiguration{" +
        "schedulingConfiguration=" + schedulingConfiguration +
        '}';
  }
}
