/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.scheduler.configuration;

import static com.mulesoft.mule.runtime.gw.api.time.period.Period.millis;

import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;

/**
 * Defines the delay and frequency {@link Period} to be applied to the scheduling of the {@link BackoffRunnable}
 */
public class SchedulingConfiguration {

  private final Period delay;
  private final Period frequency;

  private SchedulingConfiguration(Period delay, Period frequency) {
    this.delay = delay;
    this.frequency = frequency;
  }

  /**
   * Creates an instance of this with the configured delay and frequency.
   *
   * @param delay a {@link Period} of delay.
   * @param frequency a {@link Period} of frequency.
   * @return an instance of this class.
   */
  public static SchedulingConfiguration configuration(Period delay, Period frequency) {
    return new SchedulingConfiguration(delay, frequency);
  }

  /**
   * Creates an instance of this with the configured delay and no frequency.
   *
   * @param delay a {@link Period} of delay.
   * @return an instance of this class.
   */
  public static SchedulingConfiguration configuration(Period delay) {
    return new SchedulingConfiguration(delay, millis(0));
  }

  /**
   * @return a {@link Period} of delay.
   */
  public Period delay() {
    return delay;
  }

  /**
   * @return a {@link Period} of frequency.
   */
  public Period frequency() {
    return frequency;
  }

  @Override
  public String toString() {
    return "SchedulingConfiguration{" +
        "delay=" + delay +
        ", frequency=" + frequency +
        '}';
  }

  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (!(o instanceof SchedulingConfiguration))
      return false;

    SchedulingConfiguration that = (SchedulingConfiguration) o;

    if (!delay.equals(that.delay))
      return false;
    return frequency.equals(that.frequency);
  }

  @Override
  public int hashCode() {
    int result = delay.hashCode();
    result = 31 * result + frequency.hashCode();
    return result;
  }
}
