/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.scheduler.factory;

import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;

import java.util.concurrent.ScheduledExecutorService;

/**
 * Creates {@link BackoffScheduler}s.
 */
public interface BackoffSchedulerFactory {

  /**
   * Creates a {@link BackoffScheduler}. A suggested {@link ScheduledExecutorService} is provided for the creation, though it is
   * not required for the instance to use it, it will depend on this interface's implementation.
   * 
   * @param executorService for the internal use of the scheduler.
   * @return instance of {@link BackoffScheduler}.
   */
  BackoffScheduler create(ScheduledExecutorService executorService);
}
