/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.scheduler.factory;

import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;

import java.util.concurrent.ScheduledExecutorService;

/**
 * Uses the provided {@link ScheduledExecutorService} in the creation method for each {@link BackoffScheduler} instance.
 */
public class VariableExecutorBackoffSchedulerFactory implements BackoffSchedulerFactory {

  @Override
  public BackoffScheduler create(ScheduledExecutorService executorService) {
    return new BackoffScheduler(executorService);
  }
}
