/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.scheduler.observer;

import com.mulesoft.anypoint.backoff.scheduler.configuration.FastRecoveryConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.state.Stable;
import com.mulesoft.anypoint.backoff.state.Unstable;

/**
 * Defines an observer to track the stability of a fast recovery {@link BackoffRunnable}.
 */
public interface FastRecoveryObserver {

  /**
   * Notifies the fast recovery {@link BackoffRunnable} is still {@link Unstable}.
   * 
   * @param runnable the {@link Unstable} {@link BackoffRunnable}.
   * @param configuration the suggested delay and frequency if rescheduled along with its observers.
   * @return this.
   */
  FastRecoveryObserver fastRecoveryUnstable(BackoffRunnable runnable, FastRecoveryConfiguration configuration);

  /**
   * Notifies the fast recovery {@link BackoffRunnable} is now {@link Stable}.
   * 
   * @param runnable the {@link Stable} {@link BackoffRunnable}.
   * @param configuration the suggested delay and frequency if rescheduled along with its observers.
   * @return this.
   */
  FastRecoveryObserver fastRecoveryStable(BackoffRunnable runnable, FastRecoveryConfiguration configuration);

  /**
   * Notifies the fast recovery {@link BackoffRunnable} is now with {@link Error}.
   *
   * @param runnable the {@link BackoffRunnable} with {@link Error}.
   * @return this.
   */
  FastRecoveryObserver fastRecoveryAbort(BackoffRunnable runnable);
}
