/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.scheduler.observer;

import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;

/**
 * Defines an observer to track the stability of a rescheduling {@link BackoffRunnable}.
 */
public interface ReschedulingObserver {

  /**
   * Notifies the {@link BackoffRunnable} must be rescheduled with defined {@link SchedulingConfiguration}.
   * 
   * @param runnable the {@link BackoffRunnable} to rescheduled.
   * @param configuration the defined period and frequency.
   * @return this.
   */
  ReschedulingObserver reschedule(BackoffRunnable runnable, SchedulingConfiguration configuration);
}
