/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.scheduler.runnable;

import static com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration.configuration;

import com.mulesoft.anypoint.backoff.scheduler.configuration.FastRecoveryConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.observer.FastRecoveryObserver;
import com.mulesoft.anypoint.backoff.state.Stable;
import com.mulesoft.anypoint.backoff.state.State;
import com.mulesoft.anypoint.backoff.state.Unstable;

/**
 * Wraps a {@link BackoffRunnable} and notifies all {@link FastRecoveryObserver}s whether current {@link State} is
 * {@link Unstable}/{@link Stable}.
 */
public class FastRecovery implements Runnable {

  private final BackoffRunnable innerRunnable;
  private final FastRecoveryConfiguration configuration;

  public FastRecovery(BackoffRunnable runnable, FastRecoveryConfiguration configuration) {
    this.innerRunnable = runnable;
    this.configuration = configuration;
  }

  @Override
  public void run() {
    innerRunnable.run();
    innerRunnable
        .ifUnstable(() -> configuration.observers()
            .forEach(recoveryObserver -> recoveryObserver.fastRecoveryUnstable(innerRunnable, backoffConfiguration())))
        .ifError(() -> configuration.observers()
            .forEach(recoveryObserver -> recoveryObserver.fastRecoveryAbort(innerRunnable)))
        .otherwise(() -> configuration.observers()
            .forEach(recoveryObserver -> recoveryObserver.fastRecoveryStable(innerRunnable, backoffConfiguration())))
        .go();
  }

  private FastRecoveryConfiguration backoffConfiguration() {
    return new FastRecoveryConfiguration(configuration(innerRunnable.delay(), configuration.frequency()),
                                         configuration.observers());
  }
}
