/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.session;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.retry.session.ErrorSessionMetadata;

/**
 * Defines if backoff must be enabled for a certain {@link SessionMetadata} and {@link BackoffConfiguration}.
 */
public interface BackoffBarrier {

  /**
   * Defines whether backoff must be performed, depending on a {@link BackoffConfiguration}.
   */
  boolean shouldBackoff(SessionMetadata sessionMetadata, BackoffConfiguration configuration);

  /**
   * Defines whether error occurred in the execution, depending on the {@link SessionMetadata}.
   */
  default boolean gotError(SessionMetadata sessionMetadata) {
    return sessionMetadata instanceof ErrorSessionMetadata;
  }

}
