/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.state;

import static com.mulesoft.mule.runtime.gw.api.time.period.Period.seconds;
import static java.lang.Math.min;

import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;

/**
 * Defines a {@link State} where the {@link BackoffRunnable} is {@link Unstable}.
 */
public class BackingOff extends Unstable {

  public BackingOff(BackoffConfiguration configuration, BackoffBarrier backoffBarrier, int step) {
    super(configuration, backoffBarrier, step);
  }

  @Override
  public State next(SessionMetadata sessionMetadata) {
    if (backoffBarrier.gotError(sessionMetadata)) {
      return new Error(configuration, backoffBarrier, step + 1);
    } else if (backoffBarrier.shouldBackoff(sessionMetadata, configuration)) {
      return new BackingOff(configuration, backoffBarrier, min(step + 1, configuration.backoffSteps()));
    } else {
      if (step == 1 || configuration.isFastRecovery()) {
        return new Stable(configuration, backoffBarrier);
      }
      return new BackingOn(configuration, backoffBarrier, min(step - 1, configuration.backonSteps()));
    }
  }

  @Override
  public Period delay() {
    return seconds(configuration.backoff().apply(step));
  }

  @Override
  protected String name() {
    return "backoff";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BackingOff)) {
      return false;
    }

    BackingOff that = (BackingOff) o;

    return step == that.step;
  }

  @Override
  public int hashCode() {
    return step;
  }

  @Override
  public String toString() {
    return "BackingOff{" +
        "step=" + step +
        '}';
  }
}
