/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.state;


import static com.mulesoft.mule.runtime.gw.api.time.period.Period.seconds;

import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;

/**
 * Defines a {@link State} where the {@link BackoffRunnable} is in process of becoming {@link Stable} back again.
 */
public class BackingOn extends Unstable {

  public BackingOn(BackoffConfiguration configuration, BackoffBarrier backoffBarrier, int step) {
    super(configuration, backoffBarrier, step);
  }

  @Override
  public State next(SessionMetadata sessionMetadata) {
    if (backoffBarrier.gotError(sessionMetadata)) {
      return new Error(configuration, backoffBarrier, step);
    }

    boolean shouldBackoff = backoffBarrier.shouldBackoff(sessionMetadata, configuration);

    if (!shouldBackoff && step == 1) {
      return new Stable(configuration, backoffBarrier);
    }

    if (shouldBackoff) {
      return new BackingOff(configuration, backoffBarrier, step);
    }

    return new BackingOn(configuration, backoffBarrier, step - 1);
  }

  @Override
  public Period delay() {
    return seconds(configuration.backon().apply(step));
  }

  @Override
  protected String name() {
    return "backon";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BackingOn)) {
      return false;
    }

    BackingOn backingOn = (BackingOn) o;

    return step == backingOn.step;
  }

  @Override
  public int hashCode() {
    return step;
  }

  @Override
  public String toString() {
    return "BackingOn{" +
        "step=" + step +
        '}';
  }
}
