/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.state;

import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;

import static com.mulesoft.mule.runtime.gw.api.time.period.Period.seconds;

/**
 * {@link Error} state, children of this could be delaying or not running.
 */
public class Error extends State {

  protected int step;

  public Error(BackoffConfiguration configuration, BackoffBarrier backoffBarrier, int step) {
    super(configuration, backoffBarrier);
    this.step = step;
  }

  @Override
  public State next(SessionMetadata sessionMetadata) {
    if (backoffBarrier.gotError(sessionMetadata) || configuration.isFastRecovery()) {
      return new Error(configuration, backoffBarrier, step + 1);
    } else {
      return backoffBarrier.shouldBackoff(sessionMetadata, configuration)
          ? new BackingOff(configuration, backoffBarrier, step + 1)
          : new Stable(configuration, backoffBarrier);
    }
  }

  @Override
  public Period delay() {
    return seconds(configuration.backoff().apply(step));
  }

  @Override
  public State go() {
    errorClosure.ifPresent(Runnable::run);
    return resetClosures();
  }

  @Override
  public State log() {
    return this;
  }

  @Override
  public boolean equals(Object obj) {
    return obj != null && obj instanceof Error;
  }

  @Override
  public String toString() {
    return "Error{}";
  }

}

