/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.state;

import static com.mulesoft.mule.runtime.gw.api.time.period.Period.millis;

import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;

/**
 * {@link Stable} state, no child of this should be delaying.
 */
public class Stable extends State {

  public Stable(BackoffConfiguration configuration, BackoffBarrier backoffBarrier) {
    super(configuration, backoffBarrier);
  }

  @Override
  public State next(SessionMetadata sessionMetadata) {
    if (backoffBarrier.gotError(sessionMetadata)) {
      return new Error(configuration, backoffBarrier, 1);
    }
    return backoffBarrier.shouldBackoff(sessionMetadata, configuration) ? new BackingOff(configuration, backoffBarrier, 1) : this;
  }

  @Override
  public Period delay() {
    return millis(0);
  }

  @Override
  public State go() {
    stableClosure.ifPresent(Runnable::run);
    return resetClosures();
  }

  @Override
  public State log() {
    return this;
  }

  @Override
  public boolean equals(Object obj) {
    return obj != null && obj instanceof Stable;
  }

  @Override
  public String toString() {
    return "Stable{}";
  }

}

