/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.backoff.state;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;

/**
 * {@link Unstable} state, children of this could be delaying.
 */
public abstract class Unstable extends State {

  protected int step;

  public Unstable(BackoffConfiguration configuration, BackoffBarrier backoffBarrier, int step) {
    super(configuration, backoffBarrier);
    this.step = step;
  }

  @Override
  public State go() {
    unstableClosure.ifPresent(Runnable::run);
    return resetClosures();
  }

  @Override
  public State log() {
    LOGGER.debug("Applying {} step #{}: delaying polling for {} seconds.", name(), step, delay().inSeconds());
    return this;
  }

  protected abstract String name();
}
