/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.retry;

import org.mule.runtime.api.lifecycle.Disposable;

/**
 * Defines an object that will schedule a {@link Runnable} and retry its execution until successful. Each {@link Runnable} can be
 * linked to a key of type {@link T}.
 * 
 * @param <T> key's type.
 */
public interface RunnableRetrier<T> extends Disposable {

  /**
   * Schedules a task to be executed until successful.
   * 
   * @param key {@link Runnable}'s key.
   * @param runnable task to schedule.
   * @return this.
   */
  RunnableRetrier<T> scheduleRetry(T key, Runnable runnable);

  /**
   * Return whether there are task pending to execute for an specific key.
   * 
   * @param key pending task's key.
   * @return true/false.
   */
  boolean hasQueuedRunnables(T key);
}
