/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.retry.barrier;

import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.retry.BackoffRunnableRetrier;
import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.anypoint.retry.session.ErrorSessionMetadata;

/**
 * Extends {@link BackoffBarrier} with a retrier and the key (of type {@link T}) to which this object applies to.
 * 
 * @param <T> key type.
 */
public abstract class BackoffRetrierBarrier<T> implements BackoffBarrier {

  protected T key;
  protected RunnableRetrier<T> retrier;

  public void initialise(T key, BackoffRunnableRetrier<T> runnableRetrier) {
    this.key = key;
    this.retrier = runnableRetrier;
  }

  @Override
  public boolean gotError(SessionMetadata sessionMetadata) {
    return sessionMetadata instanceof ErrorSessionMetadata;
  }
}
