/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.retry.barrier;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.retry.session.RetryFailedSessionMetadata;

/**
 * Checks {@link SessionMetadata} is of type {@link RetryFailedSessionMetadata}.
 */
public class BackoffWhileRetryFails extends BackoffRetrierBarrier {

  @Override
  public boolean shouldBackoff(SessionMetadata sessionMetadata, BackoffConfiguration configuration) {
    return sessionMetadata instanceof RetryFailedSessionMetadata;
  }
}
