/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.retry.barrier;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.anypoint.retry.session.RetryFailedSessionMetadata;

/**
 * Checks {@link SessionMetadata} requires retry and no other task is queued in the {@link RunnableRetrier}. If so, it means there
 * is a newer task to be processed.
 * <p/>
 * Use this barrier when {@link BackoffRunnable BackoffRunnables} are independent from each other, and only the last one is
 * needed.
 * 
 * @param <T> type of key.
 */
public class BackoffWhilstAlone<T> extends BackoffRetrierBarrier<T> {

  @Override
  public boolean shouldBackoff(SessionMetadata sessionMetadata, BackoffConfiguration configuration) {
    return sessionMetadata instanceof RetryFailedSessionMetadata && !retrier.hasQueuedRunnables(key);
  }
}
