/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.retry.runnable;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.retry.session.ErrorSessionMetadata;
import com.mulesoft.anypoint.retry.session.RetryFailedSessionMetadata;
import com.mulesoft.anypoint.retry.session.RetrySuccessfulSessionMetadata;

/**
 * Defines a {@link BackoffRunnable} with a key of type {@link T} that returns a {@link SessionMetadata} that only depends on
 * whether the inner {@link Runnable} raises an exception or not.
 * 
 * @param <T> key type.
 */
public class RetrierRunnable<T> extends BackoffRunnable {

  private final T key;
  private final Runnable innerRunnable;

  public RetrierRunnable(T key, Runnable runnable, BackoffConfiguration configuration, BackoffBarrier barrier) {
    super(configuration, barrier);
    this.key = key;
    this.innerRunnable = runnable;
  }

  /**
   * @return {@link RetrySuccessfulSessionMetadata} if no exception has been raised, otherwise,
   *         {@link RetryFailedSessionMetadata}.
   */
  @Override
  protected SessionMetadata execute() {
    try {
      innerRunnable.run();
      return new RetrySuccessfulSessionMetadata();
    } catch (Exception e) {
      return new RetryFailedSessionMetadata();
    } catch (Throwable t) {
      return new ErrorSessionMetadata();
    }
  }

  /**
   * @return runnable key.
   */
  public T key() {
    return key;
  }

  /**
   * @return wrapped {@link Runnable}.
   */
  public Runnable inner() {
    return innerRunnable;
  }

  @Override
  public String toString() {
    return "RetrierRunnable{" +
        "key=" + key +
        ", innerRunnable=" + innerRunnable +
        '}';
  }
}
