/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.retry.session;

import static java.util.Collections.emptyList;

import com.mulesoft.anypoint.backoff.session.SessionMetadata;

import java.util.List;

/**
 * Metadata for a failed task retry attempt
 */
public class RetryFailedSessionMetadata implements SessionMetadata {

  @Override
  public int requests() {
    return 0;
  }

  @Override
  public List<Integer> statusCodes() {
    return emptyList();
  }

  @Override
  public int getCount(int statusCode) {
    return 0;
  }
}
