/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.test.backoff;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.backoff.state.State;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mule.tck.junit4.rule.LogCleanup;
import uk.org.lidalia.slf4jext.Level;

@Ignore(value="AGW-2216")
public class BackoffRunnableTestCase {
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    private TestLogger logger;

    @Test
    public void logDelayingTimeWhenBackingOff() {
        BackoffRunnable runnable = this.backoffRunnable(this.barrier(2));
        runnable.run();
        runnable.otherwise(() -> Assert.fail((String)"Runnable should remain unstable")).go();
        this.assertDebugLine("backoff", runnable);
    }

    @Test
    public void logDelayingTimeWhenBackingOn() {
        BackoffRunnable backoffRunnable = this.backoffRunnable(this.barrier(3));
        IntStream.range(0, 3).forEach(i -> backoffRunnable.run());
        backoffRunnable.otherwise(() -> Assert.fail((String)"Runnable should remain unstable")).go();
        this.assertDebugLine("backon", backoffRunnable);
    }

    private void assertDebugLine(String statusName, BackoffRunnable backoffRunnable) {
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Applying {} step #{}: delaying polling for {} seconds.", new Object[]{statusName, 1, backoffRunnable.delay().inSeconds()})));
    }

    private BackoffRunnable backoffRunnable(BackoffBarrier backoffBarrier) {
        BackoffRunnable backoffRunnable = new BackoffRunnable(this.configuration(), backoffBarrier){

            protected SessionMetadata execute() {
                return null;
            }
        };
        this.overrideStateLogger();
        return backoffRunnable;
    }

    private void overrideStateLogger() {
        this.logger = TestLoggerFactory.getTestLogger(State.class);
    }

    private BackoffConfiguration configuration() {
        return new BackoffConfiguration.Builder(true).backoff(2.0, 1.0, 5, Function.identity()).backon(2.0, 1.0, 3, Function.identity()).build();
    }

    private BackoffBarrier barrier(int amountOfFailures) {
        int[] i = new int[]{0};
        return (sessionMetadata, configuration) -> {
            i[0] = i[0] + 1;
            return i[0] < amountOfFailures;
        };
    }
}

